/*
*******************************************************************************
*
* File:         xmutxgn.c
* Description:  
* Author:       Henrik Liebau
* Created:      10 Apr 2000, 13:36:14
* Modified:     Thu Apr 20 14:58:01 2000 by Henrik Liebau, BVS R&D
* Language:     C Source File
* Package:      
* Status:       
*
* (C) Copyright 2000 by Agilent Technologies, All Rights Reserved.
*
*******************************************************************************
*/

#include <assert.h>

#include <xtypedef.h>
#include <xerrcapi.h>
#include <xmutex.h>
#include <xutil.h> /* needed for prototype of BestXMemCalloc and ..MemFree*/
/*****************************************************************************
 * mutex stuff
 *****************************************************************************/

/*---------------------------------------------------------------------------*
 * bx_errtype EXPORT BestXCreateMutex (bx_mutextype * newMutex)
 *
 * Purpose: create mutex for exclusive access 
 *---------------------------------------------------------------------------*/
bx_errtype EXPORT BestXCreateMutex (bx_mutextype * pMutex)
{
  bx_errtype retval;
  bx_mutextype theMutex;
  
  assert (pMutex != NULL);

  theMutex = (bx_mutextype) BestXMemCalloc (1, sizeof (bx_mutextype));
  
  retval = (theMutex != NULL) ? BX_E_OK:BX_E_TBD_MSG; /* TODO: find good err */

  (*pMutex) = theMutex;

  return retval;
}

/*---------------------------------------------------------------------------*
 * bx_errtype EXPORT BestXDeleteMutex (bx_mutextype * pMutex)
 *
 * Purpose: delete mutex handle;
 *---------------------------------------------------------------------------*/
bx_errtype EXPORT BestXDeleteMutex (bx_mutextype * pMutex)
{
  bx_errtype retval = BX_E_OK;
  
  assert (pMutex != NULL);

  BestXMemFree (pMutex);

  return retval;
}

/*---------------------------------------------------------------------------*
 * bx_errtype EXPORT BestXLockMutex (bx_mutextype theMutex)
 *
 * Purpose: lock and block
 *---------------------------------------------------------------------------*/
bx_errtype EXPORT BestXLockMutex (bx_mutextype theMutex)
{
  bx_errtype retval = BX_E_TBD_MSG;  /* TODO: find good error message */

  /* TODO: make this call exclusive and query! */
  (*theMutex)++;
  retval = BX_E_OK;

  return retval;
}

/*---------------------------------------------------------------------------*
 * bx_errtype EXPORT BestXUnlockMutex (bx_mutextype theMutex)
 *
 * Purpose: unlock mutex object, returns BX_E_OK on success
 *---------------------------------------------------------------------------*/
bx_errtype EXPORT BestXUnlockMutex (bx_mutextype theMutex)
{
  /* TODO: make this call exclusive and query! */
  (*theMutex)--;

  return BX_E_OK;
}

/*****************************************************************************
 * critical section stuff
 *****************************************************************************/
/*---------------------------------------------------------------------------*
 * bx_errtype EXPORT BestXCreateCriticalSection (bx_critsecttype * pCritSect)
 *
 * Purpose: create critsect for exclusive access 
 *---------------------------------------------------------------------------*/
bx_errtype EXPORT BestXCreateCriticalSection (bx_critsecttype * pCritSect)
{
  bx_errtype retval = BX_E_OK;
  
  assert (pCritSect != NULL);

  pCritSect = 0;

  return retval;
}

/*---------------------------------------------------------------------------*
 * bx_errtype EXPORT BestXDeleteCriticalSection (bx_critsecttype * pCritSect)
 *
 * Purpose: delete critsect handle;
 *---------------------------------------------------------------------------*/
bx_errtype EXPORT BestXDeleteCriticalSection (bx_critsecttype * pCritSect)
{
  bx_errtype retval = BX_E_OK;
  
  assert (pCritSect != NULL);

  return retval;
}

/*---------------------------------------------------------------------------*
 * bx_errtype EXPORT BestXEnterCriticalSection (bx_critsecttype * pCritSect)
 *
 * Purpose: enter and benter
 *---------------------------------------------------------------------------*/
bx_errtype EXPORT BestXEnterCriticalSection (bx_critsecttype * pCritSect)
{
  bx_errtype retval = BX_E_TBD_MSG; /* TODO: find good error message */

  assert (pCritSect != NULL);

  /* TODO: make this call exclusive and query! */
  (*pCritSect)++;
  retval = BX_E_OK;

  return retval;
}

/*---------------------------------------------------------------------------*
 * bx_errtype EXPORT BestXLeaveCriticalSection (bx_critsecttype * pCritSect)
 *
 * Purpose: leave critsect object, returns BX_E_OK on success
 *---------------------------------------------------------------------------*/
bx_errtype EXPORT BestXLeaveCriticalSection (bx_critsecttype * pCritSect)
{
  assert (pCritSect != NULL);

  /* TODO: make this call exclusive and query! */
  (*pCritSect)--;

  return BX_E_OK;
}

